<?php
require_once '../../../../wp-load.php';
require './chinadivision-config.php';
require './chinadivision-prefix.php';
global $wpdb;

$db_prefix = $wpdb->prefix;
if (CHINADIVISION_API_KEY == "your apikey" || CHINADIVISION_API_KEY == "") {
    echo json_encode(array("code" => 1, "msg" => "apikey can not be empty.", "data" => null));
    return;
}

if (isset($_POST['order_ids']) && $_POST['order_ids']) {
    $order_ids = $_POST['order_ids'];
} else {
    echo json_encode(array("code" => 2, "msg" => "Please choose your order checkbox.", "data" => null));
    return;
}
if(CHINADIVISION_PREFIX !== 'your prefix' && CHINADIVISION_PREFIX !== ''){
  $ids = explode(',',$order_ids);
  $order_ids = '';
  foreach($ids as $idv){
    $order_ids .= CHINADIVISION_PREFIX.$idv.",";
  }
  $order_ids = substr($order_ids,0,-1);
}
$order_ids = array( 'order_ids' => $order_ids );
// print_r($order_ids);die;
$tracking_header = array('Content-Type:application/x-www-form-urlencoded', 'apikey:' . CHINADIVISION_API_KEY,);
$tracking_url = "http://api.chinadivision.com/order-getShippedInfos";
$tracking = _curlRequest($tracking_url, "POST", json_encode($order_ids), $tracking_header);
$tracking = json_decode($tracking, true);

if ( empty($tracking['data']) || $tracking['code'] == 4  ) {
    echo json_encode(array("code" => 4, "msg" => "There are no orders to sync!", "data" => null));return;
} elseif ($tracking['code']) {
    echo json_encode(array("code" => 5, "msg" => "There was an error getting the order information!", "data" => null));return;
}
// print_r($tracking);die;
$error = "";
foreach($tracking['data'] as $k=>$v){
  $info = json_decode($v['info'],true);
  $order_id = $v['order_id'];
   if(empty($info)){
        continue;
    }
    if(CHINADIVISION_PREFIX !== 'your prefix' && CHINADIVISION_PREFIX !== ''){
      $order_id = substr($order_id,strlen(CHINADIVISION_PREFIX));
    }
    $sql = "SELECT pm.meta_value as sku FROM {$db_prefix}postmeta as pm WHERE pm.meta_key='_sku' AND pm.post_id in (SELECT oim.meta_value FROM {$db_prefix}woocommerce_order_itemmeta as oim LEFT JOIN {$db_prefix}woocommerce_order_items as oi ON (oi.order_item_id = oim.order_item_id AND (oim.meta_key='_product_id' OR oim.meta_key='_variation_id')) WHERE oi.order_item_type='line_item' AND oi.order_id ={$order_id})";
    $order_sku = $wpdb->get_results($sql,ARRAY_A);
    if(!empty($order_sku)){
      $new_sku = array();
      foreach($order_sku as $val){
        if(!empty($val['sku'])){
          $new_sku[] = $val['sku'];
        }
      }
      $sync_sku = array();
      foreach($info as $ik=>$iv){
        if($iv['sku']&& in_array($iv['sku'],$new_sku)){
            $sync_sku[] = $iv['sku'];
        }
      }
      if(!empty($sync_sku)){
        if($v['shipping_method']){
          if(!$wpdb->get_row("SELECT * FROM {$db_prefix}woocommerce_order_items WHERE order_id={$order_id} AND order_item_type='shipping' ", ARRAY_A)){
             $data = array(
                'order_item_name'=>$v['shipping_method'],
                'order_item_type'=>'shipping',
                'order_id'=>$order_id
            );
            $wpdb->insert("{$db_prefix}woocommerce_order_items",$data);
          }
        }
        if($v['tracking_number']){
          $order_items = $wpdb->get_row("SELECT * FROM {$db_prefix}woocommerce_order_items WHERE order_id={$order_id} AND order_item_type='shipping' ", ARRAY_A);
          if($order_items && !$wpdb->get_row("SELECT * FROM {$db_prefix}woocommerce_order_itemmeta WHERE order_item_id={$order_items['order_item_id']} AND meta_key='tracking_number' ", ARRAY_A)){
             $data = array(
                'order_item_id'=>$order_items['order_item_id'],
                'meta_key'=>'tracking_number',
                'meta_value'=>$v['tracking_number']
            );
            if(!$wpdb->insert("{$db_prefix}woocommerce_order_itemmeta",$data)){
              $error .= $v['order_id'].",";
            }
          }
        }
      }else{
        $error .= $v['order_id'].",";
      }
    }    
} 
if($error){
  $errorders = substr($error,0,-1);
  echo json_encode(array("code" => 6, "msg" => "Can synchronize but synchronize failed orders:{$errorders}", "data" => null));return;
}
echo json_encode(array("code" => 0, "msg" => "Success", "data" => null));return;
/** 发送cURL请求
 * @param string $url   请求地址
 * @param string $type  请求类型
 * @param array $post_data  请求数据
 * @param array $header 请求头域
 * @return mixed        响应体
 * @author tanzhixin
 */
function _curlRequest ($url = "", $type = "GET", $post_data="", $header = array()) {
      if( !in_array($type, array("GET", "POST", "PUT", "DELETE")) ){
          return false;
      }

      switch($type) {
          case "GET":
              $ch = curl_init();
              if ( !empty($header) ) { curl_setopt($ch, CURLOPT_HTTPHEADER, $header); }
              curl_setopt($ch, CURLOPT_URL, $url);
              curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
              curl_setopt($ch, CURLOPT_TIMEOUT, 2);
              curl_setopt($ch, CURLOPT_HEADER, 0);    //不输出头域
              $output = curl_exec($ch);
              curl_close($ch);
              break;

          case "POST":
              $ch = curl_init();
              if ( !empty($header) ) { curl_setopt($ch, CURLOPT_HTTPHEADER, $header); }
              curl_setopt($ch, CURLOPT_URL, $url);
              curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
              curl_setopt($ch, CURLOPT_TIMEOUT, 2);
              curl_setopt($ch, CURLOPT_POST, true);
              curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data );
              $output = curl_exec($ch);
              curl_close($ch);
              break;

          case "PUT":
              $ch = curl_init();
              if ( !empty($header) ) { curl_setopt($ch, CURLOPT_HTTPHEADER, $header); }
              curl_setopt($ch, CURLOPT_URL, $url);
              curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
              curl_setopt($ch, CURLOPT_TIMEOUT, 2);
              curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data );
              curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $type);
              $output = curl_exec($ch);
              curl_close($ch);
              break;
              
          case "DELETE":
              $ch = curl_init();
              if ( !empty($header) ) { curl_setopt($ch, CURLOPT_HTTPHEADER, $header); }
              curl_setopt($ch, CURLOPT_URL, $url);
              curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
              curl_setopt($ch, CURLOPT_TIMEOUT, 2);
              curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data );
              curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $type);
              $output = curl_exec($ch);
              curl_close($ch);
              break;

          default:
              $output = false;
              break;
      }

      return $output;
  }
